#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/svc.h>

extern Malloc_blk *_heapbottom;

static int
dumpblks(void)
{
   Malloc_blk *cp;

   for (cp = _heapbottom; cp; cp = cp->next)
   {
      printf (
	 "   blk >%04X, size = %4u, flags = %d, back = >%04X, next = >%04X\n",
	       (unsigned)cp, cp->size, cp->flags,
	       (unsigned)cp->back, (unsigned)cp->next);
   }
   return 0;
}

int
main(int argc, char **argv)
{
   char *ma[40];
   int num, size, order;
   int i;
   
   if (argc != 4)
   {
      printf ("usage: %s num size freeorder\n", argv[0]);
      return 1;
   }

   num = atoi (argv[1]);
   if (num > 40) num = 40;
   size = atoi (argv[2]);
   order = atoi (argv[3]);
   printf ("%s: num = %d, size = %d, order = %d\n",
	    argv[0], num, size, order);

   dumpblks();

   for (i = 0; i < num; i++)
   {
      ma[i] = (char *)malloc (size);
      if (!ma[i])
      {
	 num = i;
	 break;
      }
      printf ("   alloc ma[%d] = >%04X\n", i, (unsigned)ma[i]);
      dumpblks();
   }
   puts ("\n");

   switch (order)
   {
   case 2:
      for (i = num-1; i >= 0; i--)
      {
	 printf ("   free ma[%d] = >%04X\n", i, (unsigned)ma[i]);
	 if (!ma[i]) break;
	 free (ma[i]);
	 dumpblks();
      }
      break;
   default:
   case 1:
      for (i = 0; i < num; i++)
      {
	 printf ("   free ma[%d] = >%04X\n", i, (unsigned)ma[i]);
	 if (!ma[i]) break;
	 free (ma[i]);
	 dumpblks();
      }
      break;
   }

   puts ("\n   termination\n");
   dumpblks();

   return 0;
}
