#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>

int
main(int argc, char **argv)
{
   int i;
   struct stat stbuf;
   char temp[256];
   
   printf ("%s:\n", argv[0]);

   if (argc == 1)
   {
      printf ("usage: %s filename ...\n", argv[0]);
      return 1;
   }

   for (i = 1; i < argc; i++)
   {
      printf ("arg[%d] = %s\n", i, argv[i]);
      if (stat (argv[i], &stbuf) == 0)
      {
	 if (S_ISDIR(stbuf.st_mode)) putchar ('d');
	 else if (S_ISPRG(stbuf.st_mode)) putchar ('p');
	 else if (S_ISBLK(stbuf.st_mode)) putchar ('b');
	 else putchar ('-');
	 if (stbuf.st_mode & S_IRUSR) putchar ('r');
	 else putchar ('-');
	 if (stbuf.st_mode & S_IWUSR) putchar ('w');
	 else putchar ('-');
	 if (stbuf.st_mode & S_IXUSR) putchar ('x');
	 else putchar ('-');
	 if (stbuf.st_mode & S_IRGRP) putchar ('r');
	 else putchar ('-');
	 if (stbuf.st_mode & S_IWGRP) putchar ('w');
	 else putchar ('-');
	 if (stbuf.st_mode & S_IXGRP) putchar ('x');
	 else putchar ('-');
	 if (stbuf.st_mode & S_IROTH) putchar ('r');
	 else putchar ('-');
	 if (stbuf.st_mode & S_IWOTH) putchar ('w');
	 else putchar ('-');
	 if (stbuf.st_mode & S_IXOTH) putchar ('x');
	 else putchar ('-');
	 printf (" %03d %03d %6lu", stbuf.st_gid, stbuf.st_uid, stbuf.st_size);
	 strcpy (temp, ctime(&stbuf.st_atime));
	 *strchr (temp, '\n') = 0;
	 printf (" %s %s\n", temp, argv[i]);
      }
      else
	 printf ("stat failed: error = %s\n", strerror(errno));
   }

   return 0;
}
