/************************************************************************
* closedir - Close a directory.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/svc.h>
#include <dirent.h>

#if defined(DEBUGDIRIO) || defined(DEBUGSTAT)
#include "hexdump.h"
#endif

#ifndef MAXPATHNAMESIZE
#define MAXPATHNAMESIZE 255
#endif

#if !defined(dx10) && !defined(dnos)
#define d_flags d_ino
#endif

int
closedir (DIR *dp)
{
   FileTable *ft;
   int status;
   int fd;
   SVCIOBlk svc;

   /*
   ** Ensure that DIR ptr is good.
   */

   if (dp == NULL)
   {
      _errno = EBADF;
      return (-1);
   }

   bzero (&svc, sizeof(SVCIOBlk));
   svc.opcode = SVCSETPRV;
   _issue_svc ((SVCBlk *)&svc);

   fd = dp->dd_fd;
   free (dp);
   ft = &_file_table[fd];
   _errno = 0;
   status = 0;

   /*
   ** Close file
   */

   svc.opcode = SVCIO;
   svc.subopcode = CLOSE;
   svc.luno = fd;
   _issue_svc ((SVCBlk *)&svc);
   if (svc.status)
   {
      _errno = EIO;
      status = -1;
   }

   /*
   ** Release file luno
   */

   svc.subopcode = RELEASEFILE;
   _issue_svc ((SVCBlk *)&svc);

   ft->modes = 0;

   return (status);
}
