/************************************************************************
* readdir - Read a directory entry.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/svc.h>
#include <dirent.h>

#if defined(DEBUGDIRIO) || defined(DEBUGSTAT)
#include "hexdump.h"
#endif

#ifndef MAXPATHNAMESIZE
#define MAXPATHNAMESIZE 255
#endif

#if !defined(dx10) && !defined(dnos)
#define d_flags d_ino
#endif

struct dirent *
readdir (DIR *dp)
{
   struct dirent *ep;
   char *fp, *tp;
   int fd;
   int i;
   int done;
   int rec;
   int sec;
   SVCIODDisk dsksvc;
   txfcb_t fcb;

   _errno = 0;

   if (dp == NULL)
   {
      _errno = EBADF;
      return (NULL);
   }

   bzero (&dsksvc, sizeof (SVCIODDisk));
   dsksvc.opcode = SVCSETPRV;
   _issue_svc ((SVCBlk *)&dsksvc);

   ep = NULL;
   fd = dp->dd_fd;

#ifdef DEBUGDIRIO
   printf ("readdir: dp = %p, fd = %d\n", dp, fd);
#endif

   /*
   ** Read from directory, empty entries have ".." in the name
   */

   done = FALSE;
   while (!done)
   {
      sec = dp->dd_pos / TXDIRPSEC;
      rec = dp->dd_pos % TXDIRPSEC;

      if (dp->dd_sec != sec)
      {
#ifdef DEBUGDIRIO
	 printf ("READ: pos = %u, sec = %d, rec = %d\n", dp->dd_pos, sec, rec);
#endif
	 if (dp->dd_pos >= dp->dd_count) return (NULL);

	 dp->dd_sec = sec;
	 dsksvc.opcode = SVCIO;
	 dsksvc.subopcode = READBINARY;
	 dsksvc.luno = fd;
	 dsksvc.userflags = 1;
	 dsksvc.buffer = (char *) &dp->dd_buf.dir.txdir;
	 dsksvc.logicalrecordlength = sizeof(dp->dd_buf.dir.txdir);
	 dsksvc.charactercount = sizeof(dp->dd_buf.dir.txdir);
	 dsksvc.trackaddress = TXDIRAU;
	 dsksvc.sectorrecord = 1;
	 dsksvc.sectoraddress = sec;

	 _issue_svc ((SVCBlk *)&dsksvc);
	 if (dsksvc.status)
	 {
	    _errno = EIO;
	    return (NULL);
	 }
#ifdef DEBUGDIRIO
	 HEXDUMP (stdout, (char *)&dp->dd_buf.dir.txdir, TXSECLEN, 0);
#endif
      }
      dp->dd_pos++;

      if (strncmp (dp->dd_buf.dir.txdir[rec].filename, "..", 2))
         done = TRUE;
   }

   /*
   ** Read the FCB for the file.
   */

   dsksvc.opcode = SVCIO;
   dsksvc.subopcode = READBINARY;
   dsksvc.luno = fd;
   dsksvc.userflags = 1;
   dsksvc.buffer = (char *) &fcb;
   dsksvc.logicalrecordlength = sizeof(fcb);
   dsksvc.charactercount = sizeof(fcb);
   dsksvc.trackaddress = dp->dd_buf.dir.txdir[rec].filefcb;
   dsksvc.sectorrecord = 1;
   dsksvc.sectoraddress = 0;

   _issue_svc ((SVCBlk *)&dsksvc);
   if (dsksvc.status)
   {
      _errno = EIO;
      return (NULL);
   }
#ifdef DEBUGDIRIO
   printf ("FCB:\n");
   HEXDUMP (stdout, (char *)&fcb, TXSECLEN, 0);
#endif

   ep = (struct dirent *) &dp->dd_dir;
   ep->d_ino = dp->dd_pos;
   ep->d_flags = (dp->dd_buf.dir.txdir[rec].fileprot == 'U') ? 1 : 0;

   fp = dp->dd_buf.dir.txdir[rec].filename;
   tp = ep->d_name;
   for (i = 0; i < TXFILELEN && (*fp != ' '); i++) *tp++ = *fp++;
   *tp++ = '.';
   fp = dp->dd_buf.dir.txdir[rec].fileext;
   for (i = 0; i < TXEXTLEN && (*fp != ' '); i++) *tp++ = *fp++;
   *tp = '\0';

   ep->d_size = 0;
   for (i = 0; i < TXMAXEXT; i++)
   {
      if (fcb.extents[i].startau == 0xFFFF) break;
      ep->d_size += fcb.extents[i].numaus;
   }
   ep->d_size *= (TXSECAU * TXSECLEN);

   return (ep);
}
