XCCT (EXECUTE C TASK) = 0,
************************************************************************
* PURPOSE: EXECUTE A 'C' TASK, SCI MODE.
* INPUTS:
*   PROGRAM FILE:     FILE CONTAINING THE TASK.
*   TASK NAME OR ID:  IDENTIFICATION NUMBER OF THE TASK.
*   ARGS:             'C' PROGRAM ARGUMENTS.
*   STACK:            STACK MEMORY ALLOCATION IN KBYTES.
*   HEAP:             HEAP MEMORY ALLOCATION IN KBYTES.
************************************************************************
   PROGRAM FILE OR LUNO = ACNM/RANGE(0,0FF)("@$$PF"),
   TASK NAME OR ID      = NAME8/RANGE(1,0FF)("@$IT$T"),
   ARGS                 = *STRING(@$CCA),
   STACK                = RANGE(1,32)("@$CCS"),
   HEAP                 = RANGE(1,32)("@$CCH")
*
* DELETE GLOBAL SYNONYMS TO RELEASE SPACE
*
.SYN $$PF = ""
.SYN BID$ = ""
*
* SUPPLY DEFAULTS FOR STACK AND HEAP, IN K
*
.IF "&STACK", EQ, ""
   .SYN $CCS = 2
.ELSE
   .SYN $CCS = "&STACK"
.ENDIF
.IF "&HEAP", EQ, ""
   .SYN $CCH = 1
.ELSE
   .SYN $CCH = "&HEAP"
.ENDIF
*
* ASSIGN SYNONYM FOR ARGS.
*
.SYN $CCA = "&ARGS"
.SYN $$PF = "&PROGRAM FILE"
.SYN $IT$T = "&TASK NAME OR ID"
*
* ASSIGN GLOBAL LUNO TO USER'S PROGRAM FILE
*
AGL ACCESS NAME = @&PROGRAM FILE, P=YES, DISPLAY=NO
.IF @$$CC, NE, 0
   MSG T="UNABLE TO ASSIGN LUNO TO @&PROGRAM FILE"
   .EXIT
.ENDIF
*
* BID THE TASK
*
.IF "&ARGS", NE, ""
   .BID TASK = &TASK NAME OR ID, LUNO=@$$LU,
      PARMS=(@$CCS,@$CCH,@$IT$T,@&ARGS)
.ELSE
   .BID TASK = &TASK NAME OR ID, LUNO=@$$LU,
      PARMS=(@$CCS,@$CCH,@$IT$T)
.ENDIF
.SYN P$CC=@$$CC
*
* RELEASE GLOBAL LUNO
*
RGL LUNO = @$$LU
*
* SIGNAL COMPLETION
*
*MSG T="EXECUTION OF C TASK IS COMPLETE."
.SYN $$CC = @P$CC
.SYN P$CC = ""
