#include <stdio.h>
#include <string.h>

#include "diskio.h"
#include "hexdump.h"

int
main (int argc, char **argv)
{
   int unit = 0;
   int cyls, heads, sects, sectlen;
   unsigned char sector[512];

   if (argc == 2)
      unit = atoi(argv[1]);

   if (diskinit (unit) < 0)
   {
      printf ("diskgeo: can't initialize disk\n");
      return (1);
   }
   
   if (diskgeometry (unit, &cyls, &heads, &sects, &sectlen) < 0)
   {
      printf ("diskgeo: can't get disk geometry\n");
      return (1);
   }

   printf ("Disk Geometry:\n");
   printf ("   cyls = %d, heads = %d, sects = %d, sectlen = %d\n",
	   cyls, heads, sects, sectlen);

   if (sectlen == 0)
      sectlen = 256;

   if (diskread (unit, 0, 0, 0, sector, sectlen) < 0)
   {
      printf ("diskgeo: can't get read label\n");
      return (1);
   }
   printf ("disk label: \n");
   hexdump (stdout, sector, 0, sectlen);

   if (diskread (unit, 0, 1, 0, sector, sectlen) < 0)
   {
      printf ("diskgeo: can't get read t1 loader\n");
      return (1);
   }
   printf ("t1 loader: \n");
   hexdump (stdout, sector, 0, sectlen);
}
