/***********************************************************************
*
* DUMPROM - Dumps a TI990 ROM image file.
*
* Changes:
*      06/20/04   DGP   Original.
*
***********************************************************************/
 
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include "hexdump.h"

int
main (int argc, char **argv)
{
   FILE *fd;
   char *pp;
   int i;
   int model;
   int page, pages;
   unsigned char buf[1024];
   
   if (argc != 3)
   {
      fprintf (stderr, "usage: dumprom model file \n");
      exit (1);
   }

   model = 0;
   for (pp = argv[1]; *pp; pp++)
   {
      if (isdigit (*pp))
      {
	 model = (model * 10) + (*pp - '0');
      }
      else
      {
	 if (*pp == 'a' || *pp == 'A')
	 {
	    if (model == 10) model = 11;
	    else goto BAD_MODEL;
	    break;
	 }
	 else
	 {
	 BAD_MODEL:
	    fprintf (stderr, 
		     "Invalid model specification %s\n", argv[i]);
	    exit (1);
	 }
      }
   }
   if (!(model ==  4 || model ==  5 || model == 9 ||
	 model == 10 || model == 11 || model == 12))
   {
      fprintf (stderr, "Unsupported CPU model: %s\n", argv[i]);
      exit (1);
   }

   pages = 1;
   if (model == 5) pages = 2;
   else if (model > 10) pages = 8;

   if ((fd = fopen (argv[2], "rb")) == NULL)
   {
      perror ("Can't open file");
      exit (1);
   }

   for (page = 0; page < pages; page++)
   {
      printf ("ROM Page %d:\n", page);
      for (i = 0; i < 1024; i++)
         buf[i] = fgetc (fd);
      HEXDUMP (stdout, (char *)buf, 1024, 0);
   }
   return (0);
}
