/***********************************************************************
*
* getfpy - Gets the FD800 floppy image from the TI computer. Use in
*          conjunction with the 990 program dfpy.asm
*
* Changes:
*      06/15/03   DGP   Original
*
***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <string.h>
#include <memory.h>
#include <ctype.h>
#include <termios.h>

#include "fd800defs.h"

#define DISKSIZE  FPYSECLEN*FPYSECTRK*FPYTRKDRV

struct termios cmdtty, runtty;
int fd;

/*
** Terminal routines borrowed from Bub Supnik's simh
*/

int
ttinit (FILE *ifd)
{
   fd = fileno(ifd);
   if (tcgetattr (fd, &cmdtty) < 0) return -1;		/* get old flags */
   runtty = cmdtty;
   runtty.c_lflag = runtty.c_lflag & ~(ECHO | ICANON);	/* no echo or edit */
   runtty.c_oflag = runtty.c_oflag & ~OPOST;		/* no output edit */
   runtty.c_iflag = runtty.c_iflag & ~ICRNL;		/* no cr conversion */
   runtty.c_cc[VINTR] = 0;				/* interrupt */
   runtty.c_cc[VQUIT] = 0;				/* no quit */
   runtty.c_cc[VERASE] = 0;
   runtty.c_cc[VKILL] = 0;
   runtty.c_cc[VEOF] = 0;
   runtty.c_cc[VEOL] = 0;
   runtty.c_cc[VSTART] = 0;				/* no host sync */
   runtty.c_cc[VSUSP] = 0;
   runtty.c_cc[VSTOP] = 0;
#if defined (VREPRINT)
   runtty.c_cc[VREPRINT] = 0;				/* no specials */
#endif
#if defined (VDISCARD)
   runtty.c_cc[VDISCARD] = 0;
#endif
#if defined (VWERASE)
   runtty.c_cc[VWERASE] = 0;
#endif
#if defined (VLNEXT)
   runtty.c_cc[VLNEXT] = 0;
#endif
   runtty.c_cc[VMIN] = 0;				/* no waiting */
   runtty.c_cc[VTIME] = 0;
#if defined (VDSUSP)
   runtty.c_cc[VDSUSP] = 0;
#endif
#if defined (VSTATUS)
   runtty.c_cc[VSTATUS] = 0;
#endif
   return 0;
}

int
ttrunstate (void)
{
   runtty.c_cc[VINTR] = 0;
   if (tcsetattr (fd, TCSAFLUSH, &runtty) < 0) return -1;
   return 0;
}

int
ttcmdstate (void)
{
   if (tcsetattr (fd, TCSAFLUSH, &cmdtty) < 0) return -1;
   return 0;
}

int
ttclose (void)
{
   return ttcmdstate ();
}

int
poll_kbd (void)
{
   int status;
   unsigned char buf[1];

   status = read (fd, buf, 1);
   if (status != 1) return -1;
   else return (buf[0]);
}

/***********************************************************************
* Main program.
***********************************************************************/

int
main(int argc, char **argv)
{
   FILE *iterm;
   FILE *oterm;
   FILE *ofd;
   int track = 0;
   int i;
   int c;
   int memory[DISKSIZE];

   /*
   ** Check args
   */

   if (argc != 2)
   {
      fprintf (stderr, "usage: getfpy floppy.file\n");
      exit (1);
   }

   /*
   ** Open the disk image file
   */

   if ((ofd = fopen (argv[1], "wb")) == NULL)
   {
      perror ("Can't open file");
      exit (1);
   }

   /*
   ** Set up the port
   */

   if ((iterm = fopen ("/dev/ttyS0", "rb")) == NULL)
   {
      perror ("Can't open terminal");
      exit (1);
   }
   if ((oterm = fopen ("/dev/ttyS0", "w")) == NULL)
   {
      perror ("Can't open terminal");
      exit (1);
   }

   ttinit (iterm);

   /*
   ** Tell the dfpy program to go
   */

   fputc ('\n', oterm);

   ttrunstate();

   /*
   ** Read the entire disk to memory
   */

   for (i = 0; i < DISKSIZE; i++)
   {
      while ((c = poll_kbd()) == -1) ;
      memory[i] = c;
      if (i % (FPYSECTRK*FPYSECLEN) == 0) printf ("track %d\n", track++);
   }
   ttcmdstate();
   ttclose();

   /*
   ** Dump the disk image
   */

   for (i = 0; i < DISKSIZE; i++)
   {
      if (fputc (memory[i], ofd) < 0)
      {
         perror ("Write error");
	 goto DIE;
      }
   }

   /*
   ** Clean up and quit
   */

DIE:
   fclose (iterm);
   fclose (oterm);
   fclose (ofd);

   return (0);
}
