/***********************************************************************
*
* support.c - Support routines for the TI 990 utilities.
*
* Changes:
*   04/02/14   DGP   Split from other programs.
*
***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <time.h>

/***********************************************************************
* tapereadint - Read an integer.
***********************************************************************/

int
tapereadint (FILE *fd)
{
   int r;

   r = fgetc (fd);
   r = r | (fgetc (fd) << 8);
   r = r | (fgetc (fd) << 16);
   r = r | (fgetc (fd) << 24);
   if (feof(fd)) return (-2);
   return (r);
}

/***********************************************************************
* tapewriteint - Write an integer.
***********************************************************************/

void
tapewriteint (FILE *fd, int v)
{
   v &= 0x7FFF;
   fputc (v & 0xFF, fd);
   fputc ((v >> 8) & 0xFF, fd);
   fputc ((v >> 16) & 0xFF, fd);
   fputc ((v >> 24) & 0xFF, fd);
}

/***********************************************************************
* dskreadint - Read an integer.
***********************************************************************/

int
dskreadint (FILE *fd)
{
   int r;
   int i;

   r = 0;
   for (i = 0; i < 4; i++)
   {
      int c;
      if ((c = fgetc (fd)) < 0) return (-1);
      r = (r << 8) | (c & 0xFF);
   }
   return (r);
}

/***********************************************************************
* dskwriteint - Write an integer.
***********************************************************************/

int
dskwriteint (FILE *fd, int num)
{
   if (fputc ((num >> 24) & 0xFF, fd) < 0) return (-1);
   if (fputc ((num >> 16) & 0xFF, fd) < 0) return (-1);
   if (fputc ((num >> 8) & 0xFF, fd) < 0) return (-1);
   if (fputc (num & 0xFF, fd) < 0) return (-1);
   return (0);
}

/***********************************************************************
* getnum - Get a number from the command.
***********************************************************************/

int
getnum (char *bp)
{
   char *cp;
   int i = 0;

   if (*bp == 'x' || *bp == '0')
   {
      i = strtol (++bp, &cp, 16);
   }
   else if (isdigit (*bp) || *bp == '-' || *bp == '+')
   {
      i = strtol (bp, &cp, 10);
   }
   return (i);
}
