/***********************************************************************
*
* tx990types.h - Definition for TX990 disk formats.
*
* Changes:
*   12/17/08   DGP   Original.
*
***********************************************************************/

#ifndef __TX990TYPES_H__
#define __TX990TYPES_H__

/*
** Location of things
*/

#define TXLABELAU 4		/* Disk label AU */
#define TXDIRAU 5		/* Disk directory AU start */

#define TXLABELLEN 32		/* Length of volume label */
#define TXEYELEN 2		/* Length of volume eye catcher */
#define TXVOLNAMLEN 4		/* Length of volume namne */

#define TXDIRPSEC 8		/* Directory entries per sector */
#define TXFILELEN 7		/* Length of the file name */
#define TXEXTLEN 3		/* Length of the file name extension */

#define TXFCBEYELEN 4		/* Length of FCB eye catcher */
#define TXMAXEXT 10		/* Maximum extents for file */

/*
** Standard File control codes
*/

#define ENDOFRECORD 0xFF
#define COMPBLANKS 0xFE
#define ENDOFFILE 0xFB
#define BINARYESCAPE 0xFA

typedef struct
{
   char label[TXLABELLEN];	/* Volume label */
   uint16 bootfcb;		/* Location of file to boot */
   char txeye[TXEYELEN];	/* TX Eye catcher 'TX' */
   char filler1[2];
   char volname[TXVOLNAMLEN];	/* Volume name */
   char filler2[86];
} disklabel_t;

typedef struct
{
   char filename[TXFILELEN];	/* File name */
   char fileext[TXEXTLEN];	/* File name extension */
   uint16 filefcb;		/* Location of file fcb */
   char fileprot;		/* File protection */
   char filler1[3];
} txdir_t;

typedef struct
{
   uint16 startau;		/* Starting AU location of block */
   uint16 numaus;		/* Number of AUs in block */
} txextent_t;

typedef struct
{
   uint16 fil1;
   char fcbeye[TXFCBEYELEN];	/* FCB eye catcher */
   uint16 fil2;
   uint16 fil3;
   uint16 fil4;
   uint16 fil5;
   uint16 fil6;
   uint16 fil7;
   uint16 fil8;
   txextent_t extents[TXMAXEXT];
} txfcb_t;

#endif
