/***********************************************************************
*
* ucsdtypes.h - Definition for UCSD Pascal.
*
* Changes:
*   12/17/08   DGP   Original. Info gleaned from I5.Sources
*
***********************************************************************/

#ifndef __UCSDTYPES_H__
#define __UCSDTYPES_H__

#include "utiltypes.h"

#define PASDIRBLK 2		/* Location of directory block */
#define PASBLKLEN 512		/* Size of block on disk */
#define PASSECBLK 4		/* Sectors per block */
#define PASDIRLEN 2048		/* Length of directory area */

#define PASVOLLEN 7		/* Volume name length */
#define PASNAMLEN 15		/* File name length */
#define PASMAXDIR 77		/* Maximum entries in a directory */

#define PASDLE 16		/* Blank compression code */
#define PASEOL 13		/* End of Line ASCII CR */

enum FILEKIND
{
   UNTYPEDFILE, XDSKFILE,    CODEFILE,    TEXTFILE,    INFOFILE,
   DATAFILE,    GRAFFILE,    FOTOFILE,    SECUREDIR
};

typedef struct
{
   char dvid[PASVOLLEN+1];	/* Name of disk volume */
   uint16 deovblk;		/* Lastblock of volume */
   uint16 dnumfiles;		/* Number of files in directory */
   uint16 dloadtime;		/* Time of last access */
   uint16 dlastboot;		/* Most recent data setting */
} pasvolent_t;

typedef struct
{
   char dtid[PASNAMLEN+1];	/* Name of file */
   uint16 dlastbyte;		/* Number of bytes in last block */
   uint16 daccess;		/* Last modification date */
} pasfilent_t;

typedef struct
{
   uint16 dfirstblk;		/* First physical disk address */
   uint16 dlastblk;		/* Points to block following */
   uint16 dfkind;		/* Kind of file for this entry */
   union
   {
      pasvolent_t volent;
      pasfilent_t filent;
   } filekind;
} pasdir_t;

/*
** Pascal file types
*/

static char *pasfiletypes[] = {
   "UNTYPEDFILE", "DSKFILE", "Codefile", "Textfile", "Infofile",
   "Datafile",    "Graffile", "Fotofile", "SecureDIR"
};

static char *pasmonths[] = {
   "", "Jan", "Feb", "Mar", "Apr", "May", "Jun",
       "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};

#endif
