/***********************************************************************
*
* DPI - Hexdump a program image.
*
* Changes:
*   09/03/13   DGP   Original
*
***********************************************************************/
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/param.h>

#define MAXMEMSIZE 32768

#include "hexdump.h"
#include "support.h"

/***********************************************************************
* getint - Get an integer from "memory".
***********************************************************************/

static int
getint (char *mem, int addr)
{
   int r;

   r = mem[addr] << 8 | mem[addr+1];
   return (r & 0xFFFF);
}


/***********************************************************************
* main
***********************************************************************/

int
main (int argc, char **argv)
{
   FILE *fd;
   char *infile;
   char *bp;
   char *mem;
   char *loadmem;
   int i;
   int size;
   int ch;
   int reclen;
   int reccnt;
   int dumprecs;
   int loadrecs;
   int loadlen;
   int alloclen;

   /*
   ** Scan off args 
   */

   infile = NULL;
   reclen = MAXMEMSIZE;
   alloclen = MAXMEMSIZE;
   dumprecs = 0;

   for (i = 1; i < argc; i++)
   {
      bp = argv[i];

      if (*bp == '-')
      {
         for (bp++; *bp; bp++) switch (*bp)
         {
	 case 'd':
	    dumprecs = 1;
	    break;

	 case 'r':
	    i++;
	    reclen = atoi (argv[i]);
	    break;

         default:
      USAGE:
	    printf ("usage: dpi [-options] in.file \n");
            printf (" options:\n");
            printf ("    -r NN        - Record length\n");
	    return (1);
         }
      }
      else if (!infile)
      {
        infile = argv[i];
      }
      else
      {
         goto USAGE;
      }

   }
   if (!infile) goto USAGE;

   if ((mem = malloc (alloclen)) == NULL)
   {
      fprintf (stderr, "hd: Can't allocate memory\n");
      exit (1);
   }

   if ((fd = fopen (infile, "rb")) == NULL)
   {
      perror ("dpi: Can't open input file");
      free (mem);
      exit (1);
   }

   size = 0;
   reccnt = 0;

   /* Skip overhead record */

   size = tapereadint (fd);
   fread (mem, size, 1, fd);
   if (dumprecs)
   {
      fprintf (stderr, "Record: %d\n", reccnt++);
      HEXDUMP (stderr, mem, size, 0);
   }
   tapereadint (fd);

   /* Read directory record */

   size = tapereadint (fd);
   fread (mem, size, 1, fd);
   if (dumprecs)
   {
      fprintf (stderr, "Record: %d\n", reccnt++);
      HEXDUMP (stderr, mem, size, 0);
   }
   tapereadint (fd);
   loadlen = getint (mem, 0x20);
   loadrecs = (loadlen + 255) >> 8;

   loadmem = mem;
   for (; loadrecs; loadrecs--)
   {
      size = tapereadint (fd);
      if (size < 0) break;
      fread (loadmem, size, 1, fd);
      if (dumprecs)
      {
	 fprintf (stderr, "Record: %d\n", reccnt++);
	 HEXDUMP (stderr, loadmem, size, 0);
      }
      tapereadint (fd);
      loadmem += size;
   }

   printf ("Program dump: loadlen = %04x\n", loadlen);
   HEXDUMP (stdout, mem, loadlen, 0);

   fclose (fd);
   free (mem);
   
   return (0);
}
