/***********************************************************************
*
* MKDISK - Make a TI990 TILINE disk image file.
*
* Changes:
*      12/17/03   DGP   Original
*      07/15/04   DGP   Corrected DS80 info.
*      07/20/16   DGP   Set INV value in sector 0.
*
***********************************************************************/
 
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>

#define NORMAL		0
#define ABORT		16

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#include "simdsk.h"
#include "support.h"

/***********************************************************************
* main
***********************************************************************/

int
main (int argc, char **argv)
{
   FILE *dfd;
   char *bp;
   char *diskfile;
   char *diskname;
   int disksize;
   int i, j;
   int diskndx;
   int verbose;

   verbose = FALSE;
   diskfile = NULL;
   diskname = NULL;

   /*
   ** Scan off args 
   */

   for (i = 1; i < argc; i++)
   {
      bp = argv[i];

      if (*bp == '-')
      {
         for (bp++; *bp; bp++) switch (*bp)
         {
	 case 'd':
	    i++;
	    diskname = argv[i];
	    break;

	 case 'v':
	    verbose = TRUE;
	    break;

         default:
      USAGE:
	    printf ("usage: mkdisk [-options] disk.file\n");
            printf (" options:\n");
	    printf ("    -d dskmodel  - Disk model\n");
	    printf ("          ");
	    for (j = i = 0; i < MAXDISKS; i++)
	    {
	       if (j >= 60)
	       {
		  printf ("\n          ");
		  j = 0;
	       }
	       printf ("%s ", disks[i].model);
	       j += strlen (disks[i].model) + 1;
	    }
	    printf ("\n");
            printf ("    -v           - Verbose output\n");
	    return (ABORT);
         }
      }

      else
      {
         if (diskfile) goto USAGE;
         diskfile = argv[i];
      }

   }

   if (!diskfile) goto USAGE;
   if (!diskname) diskname = "DS10";

   /*
   ** Check disk model
   */

   for (diskndx = 0; diskndx < MAXDISKS; diskndx++)
   {
      if (!strcmp (diskname, disks[diskndx].model)) break;
   }
   if (diskndx == MAXDISKS)
   {
      printf ("mkdisk: Unknown disk model: %s\n", diskname);
      exit (ABORT);
   }

   /*
   ** Calulate the size of the disk
   */

   disksize = (disks[diskndx].bytsec + disks[diskndx].overhead)
         * disks[diskndx].sectrk * disks[diskndx].heads *
	 disks[diskndx].cyls;

   if (verbose)
   {
      float size;
      size = disksize / 1048576.0;
      printf ("mkdisk: create disk %s on file %s\n", diskname, diskfile);
      printf (
"Geometry: cyls = %d, heads = %d, sec/trk = %d, byte/sec = %d, overhead = %d\n",
		  disks[diskndx].cyls, disks[diskndx].heads,
		  disks[diskndx].sectrk, disks[diskndx].bytsec,
		  disks[diskndx].overhead);
      printf (" Disk size = %6.2f MB\n", size);
   }

   /*
   ** Open the disk image file
   */

   if ((dfd = fopen (diskfile, "wb")) == NULL)
   {
      perror ("mkdisk: Can't open diskfile");
      exit (ABORT);
   }

   /*
   ** Write the disk geometry information
   */

   dskwriteint (dfd, disks[diskndx].cyls);
   dskwriteint (dfd, disks[diskndx].heads);
   dskwriteint (dfd, (disks[diskndx].overhead << 8) | disks[diskndx].sectrk);
   dskwriteint (dfd, disks[diskndx].bytsec);

   /*
   ** Write the disk image
   */

   for (i = 0; i < disksize; i++)
   {
      if (i == 0xA5) /* Mark INV done */
	 fputc (0x02, dfd);
      else
	 fputc (0, dfd);
   }
   
   fclose (dfd);
   return (NORMAL);

}
