/***********************************************************************
*
* xferdisk - converts the disk image from to an image without overhead.
*
* Changes:
*      06/30/04   DGP   Original
*
***********************************************************************/
 
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <ctype.h>
#include <sys/ioctl.h>
#include <termios.h>

#define NORMAL	0
#define ABORT	16

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#include "simdsk.h"
#include "support.h"

/***********************************************************************
* Main program.
***********************************************************************/

int
main(int argc, char **argv)
{
   int  *memory;
   FILE *indisk;
   FILE *outdisk;
   int track = 0;
   int diskndx;
   int indisksize;
   int intracksize;
   int outdisksize;
   int outtracksize;
   int i, k;
   int c;

   /*
   ** Check args
   */

   if (argc != 4)
   {
      fprintf (stderr, "usage: xferdisk model disk.filein disk.fileout\n");
      exit (ABORT);
   }

   /*
   ** Check disk model
   */

   for (diskndx = 0; diskndx < MAXDISKS; diskndx++)
   {
      if (!strcmp (disks[diskndx].model, argv[1])) break;
   }
   if (diskndx == MAXDISKS)
   {
      printf ("getdisk: Unknown disk model: %s\n", argv[1]);
      exit (ABORT);
   }

   /*
   ** Calculate the size of the in disk and track for display
   */

   intracksize = (disks[diskndx].overhead + disks[diskndx].bytsec) *
	       disks[diskndx].sectrk;
   indisksize = intracksize * disks[diskndx].heads * disks[diskndx].cyls;

   printf ("%s: disksize = %d, tracksize = %d\n\n",
	    argv[1], indisksize, intracksize);


   /*
   ** Calculate the size of the out disk and track less overhead for transfer
   */

   outtracksize = disks[diskndx].bytsec * disks[diskndx].sectrk;
   outdisksize = outtracksize * disks[diskndx].heads * disks[diskndx].cyls;

   /*
   ** Allocate the needed memory
   */

   if ((memory = (int *)malloc (outdisksize * sizeof(int))) == NULL)
   {
      printf ("getdisk: Can't malloc memory\n");
      exit (ABORT);
   }

   /*
   ** Open the disk image files
   */

   if ((indisk = fopen (argv[2], "rb")) == NULL)
   {
      perror ("Can't open input disk file");
      exit (ABORT);
   }

   if ((outdisk = fopen (argv[3], "wb")) == NULL)
   {
      perror ("Can't open output disk file");
      exit (ABORT);
   }

   /*
   ** Write the disk geometry information
   */

   dskwriteint (outdisk, disks[diskndx].cyls);
   dskwriteint (outdisk, disks[diskndx].heads);
   dskwriteint (outdisk, disks[diskndx].sectrk);
   dskwriteint (outdisk, disks[diskndx].bytsec);

   /*
   ** Read the entire disk to memory
   */

   for (k = outtracksize, i = 0; i < outdisksize; i++)
   {
      if ((c = fgetc (indisk)) < 0)
      {
         perror ("Read error");
	 goto DIE;
      }
      memory[i] = c;
      k--;
      if (k == 0)
      {
	 printf ("track %d\n", track++);
	 if (disks[diskndx].overhead)
	 {
	    for (k = 0; k < disks[diskndx].overhead; k++) fgetc (indisk);
	 }
	 k = outtracksize;
      }
   }

   /*
   ** Dump the disk image
   */

   for (i = 0; i < outdisksize; i++)
   {
      if (fputc (memory[i], outdisk) < 0)
      {
         perror ("Write error");
	 goto DIE;
      }
   }

   /*
   ** Clean up and quit
   */

DIE:
   fclose (indisk);
   fclose (outdisk);
   return (NORMAL);

}
