	IDT	'DROM10A'
	TITL	'Dump /10a ROM to serial port'
*
* DROM10A - Dumps rom to serial port
*
R0	EQU	0
R1	EQU	1
R2	EQU	2
R3	EQU	3
R4	EQU	4
R5	EQU	5
R6	EQU	6
R7	EQU	7
R8	EQU	8
R9	EQU	9
R10	EQU	10
R11	EQU	11
R12	EQU	12
R13	EQU	13
R14	EQU	14
R15	EQU	15
*
* Terminal CRU bits
*
TRMCRU	EQU	>0
XMIT	EQU	8
DTR	EQU	9
RTS	EQU	10
WRQ	EQU	11
RRQ	EQU	12
NSF	EQU	13
ENINT	EQU	14
*
ROMADR	EQU	>FC00
ROMSIZ	EQU	1024
*
ROMCRU	EQU	>1FB4
PNLCRU	EQU	>1FE0
*
	DXOP	SVC,15
	PAGE
*
* Task Entry
*
	DATA	WS,ENTRY,0
*
*
* Standalone Entry
*
ENTRY	EQU	$
	SETO	R14		Task entry set flag.
SAENT	EQU	$
	LWPI	WS
	LIMI	0		Take over the system
	SBO	DTR
	SBO	RTS
	SBZ	ENINT
	BLWP	@PRINT		Issue ready message
	DATA	READY,RDYLEN
WAITCH	EQU	$
	TB	RRQ
	JNE	$-2
	STCR	R1,8		Get reply
	SBZ	RRQ
	CB	R1,@KILL	If ch = KILL then
	JEQ	XIT		  EXIT
	CB	R1,@NEWLIN	If ch != NEWLINE then
	JNE	WAITCH		   wait
*
	MOV	R11,R12		Set ROM select CRU address
	CLR	R4		Rom page select
LOOP	EQU	$
	LDCR	R4,3		select it.
	BLWP	@PRINT		Send it out page 
	DATA	ROMADR,ROMSIZ
	MOV	R0,R0
	JNE	XIT		Sent back a KILL
	AB	R6,R4		Select next page
	CB	R7,R4		Last page?
	JNE	LOOP		No, go select.
*
XIT	EQU	$
	MOV	R14,R14		If task entry then
	JEQ	SADONE
	MOV	R9,R12		   restore terminal CRU
	LIMI	15		   retstore task
	SBO	ENINT
	SVC	R13		   exit
SADONE	EQU	$
	MOV	R10,R12		Put status on front panel
	LDCR	R15,8
	SWPB	R15
	LDCR	R15,8
	IDLE			Yes, we're done.
*
WS	DATA	0,0,0,0,0,0,>0100,>0800
	DATA	0,TRMCRU,PNLCRU,ROMCRU,TRMCRU,>0400,0,0
*
READY	EQU	$
	BYTE	>0D
NEWLIN  BYTE	>0A
	TEXT	'Enter NEWLINE key when ready: '
RDYLEN	EQU	$-READY
*
	PAGE
*
* Print a message
*
PRINT	DATA	PRWS,PRENT
PRENT	EQU	$
	MOV	*R14+,R2	Get buffer address
	MOV	*R14+,R1	Get message length
	SBO	DTR
	SBO	RTS
PRI010	EQU	$
	LDCR	*R2+,8
	TB	WRQ
	JNE	$-2
	SBZ	WRQ
	TB	RRQ		Any thing coming back?
	JEQ	PRI030
PRI020	EQU	$
	DEC	R1
	JGT	PRI010
	CLR	@0(R13)		Done, exit 0.
	RTWP
*
PRI030	EQU	$
	STCR	R5,8		Get it.
	SBZ	RRQ
	SRL	R5,8
	CB	R5,R11		If XOFF then
	JEQ	PRI040		   go wait for XON
	CB	R5,R9		If not KILL (CTRL-C) then
	JNE	PRI020		   Ignore.
	SETO	@0(R13)		else exit -1.
	RTWP
PRI040	EQU	$
	TB	RRQ		Wait for XON.
	JNE	PRI040
	STCR	R5,8
	SBZ	RRQ
	SRL	R5,8
	CB	R5,R10
	JEQ	PRI020
	JMP	PRI040
*
PRWS	DATA	0,0,0,0,0,0,0,0
	DATA	0
KILL	DATA	>0300		CTRL-C
XON	DATA	>1100
XOFF	DATA	>1300
	DATA	TRMCRU,0,0,0
	PAGE
	END	SAENT
