	IDT	'DROM5'
	TITL	'Dump /5 Self-test ROM to serial port'
*
* DROM5 - Dumps /5 Self-test rom to serial port
*
R0	EQU	0
R1	EQU	1
R2	EQU	2
R3	EQU	3
R4	EQU	4
R5	EQU	5
R6	EQU	6
R7	EQU	7
R8	EQU	8
R9	EQU	9
R10	EQU	10
R11	EQU	11
R12	EQU	12
R13	EQU	13
R14	EQU	14
R15	EQU	15
*
* Terminal CRU bits
*
TRMCRU	EQU	>0
XMIT	EQU	8
DTR	EQU	9
RTS	EQU	10
WRQ	EQU	11
RRQ	EQU	12
NSF	EQU	13
KILL	EQU	>03		CTRL-C
XON	EQU	>11
XOFF	EQU	>13
*
ROMADR	EQU	>F800
ROMSIZ	EQU	1024
	PAGE
*
* Task Entry
*
	DATA	WS,ENTRY,0
*
* Standalone Entry
*
SAENT	EQU	$
	LWPI	WS
ENTRY	EQU	$
	LIMI	0		Take over the system
	LI	R12,>17F8
	SBO	0
	LI	R12,TRMCRU
	SBO	DTR
	SBO	RTS
	BLWP	@PRINT		Issue ready message
	DATA	READY,RDYLEN
	TB	RRQ
	JNE	$-2
	STCR	R1,8		Get reply
	SBZ	RRQ
*
	BLWP	@PRINT		Send it out
	DATA	ROMADR,ROMSIZ
	LI	R12,>17FB
	SBZ	0
	MOV	R0,R0
	JNE	OOPS		Sent back a KILL
	IDLE
*
OOPS	EQU	$
	IDLE
*
WS	DATA	0,0,0,0,0,0,0,0
	DATA	0,0,0,0,TRMCRU,0,0,0
*
READY	TEXT	'Enter any key when ready:'
	BYTE	>0D,>0A
RDYLEN	EQU	$-READY
*
	PAGE
*
* Print a message
*
PRINT	DATA	PRWS,PRENT
PRENT	EQU	$
	MOV	*R14+,R2	Get buffer address
	MOV	*R14+,R1	Get message length
	SBO	DTR
	SBO	RTS
PRI010	LDCR	*R2+,8
	TB	WRQ
	JNE	$-2
	SBZ	WRQ
	TB	RRQ		Any thing coming back?
	JEQ	PRI030
PRI020	EQU	$
	DEC	R1
	JGT	PRI010
	CLR	@0(R13)		Done, exit 0.
	RTWP
*
PRI030	EQU	$
	STCR	R5,8		Get it.
	SBZ	RRQ
	SRL	R5,8
	CI	R5,XOFF		If XOFF then
	JEQ	PRI040		   go wait for XON
	CI	R5,KILL		If not KILL (CTRL-C) then
	JNE	PRI020		   Ignore.
	SETO	@0(R13)		else exit -1.
	RTWP
PRI040	EQU	$
	TB	RRQ		Wait for XON.
	JNE	PRI040
	STCR	R5,8
	SBZ	RRQ
	SRL	R5,8
	CI	R5,XON
	JEQ	PRI020
	JMP	PRI040
*
PRWS	DATA	0,0,0,0,0,0,0,0
	DATA	0,0,0,0,TRMCRU,0,0,0
	PAGE
	END	SAENT
