/***********************************************************************
*
* DUMPFPY - Dumps a TI990 floppy image file.
*
* Changes:
*      06/20/04   DGP   Original.
*
***********************************************************************/
 
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <errno.h>
#include <ctype.h>

#include "utiltypes.h"
#include "fd800defs.h"

#define NORMAL		0
#define ABORT		16

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#include "hexdump.h"

/***********************************************************************
* main
***********************************************************************/

int
main (int argc, char **argv)
{
   FILE *fd;
   char *fname;
   int dskloc;
   int i;
   int j;
   int tracks, sectrk, sectlen;
   int tracklen;
   int track;
   int start, end;
   char buf[288];
   
   fname = NULL;
   track = 0;
   start = 0;
   end = 0;
   for (i = 1; i < argc; i++)
   {
      switch (i)
      {
      case 1:
         fname = argv[i];
	 break;
      case 2:
         track = atoi(argv[i]);
	 break;
      case 3:
         start = atoi(argv[i]);
	 end = start;
	 break;
      case 4:
         end = atoi(argv[i]);
	 break;
      default:
      USAGE:
	 fprintf (stderr,
	    "usage: dumpfpy floppy.file [track [startsec [endsec]]]\n");
	 exit (ABORT);
      }
   }
   if (fname == NULL) goto USAGE;

   /*
   ** Open the disk image file
   */

   if ((fd = fopen (fname, "rb")) == NULL)
   {
      perror ("Can't open disk file");
      exit (ABORT);
   }

   /*
   ** Setup the disk geometry
   */

   tracks = FPYTRKDRV;
   sectrk = FPYSECTRK;
   sectlen = FPYSECLEN;

   tracklen = sectrk * sectlen;

   printf ("FD800 disk geometry:\n");
   printf ("   tracks    = %d\n", tracks);
   printf ("   sectrk    = %d\n", sectrk);
   printf ("   sectlen   = %d\n", sectlen);
   printf ("   tracklen  = %d\n", tracklen);
   printf ("   disk size = %d bytes\n", tracklen * tracks);

   if (track >= tracks)
   {
      printf ("Invalid disk track specified, abort\n");
      exit (ABORT);
   }
   if (start >= sectrk)
   {
      printf ("Invalid disk start sector specified, abort\n");
      exit (ABORT);
   }
   if (end >= sectrk)
   {
      printf ("Invalid disk end sector specified, abort\n");
      exit (ABORT);
   }

   for (j = start; j <= end; j++)
   {
      /*
      ** Calculate location
      */

      dskloc = (tracklen * track) + (sectlen * j);

#ifdef DEBUG
      printf ("   track = %d, sector = %d\n",
	       track, start);
      printf ("   dskloc = %d\n", dskloc);
#endif

      /*
      ** Go to the specified location on disk
      */

      if (fseek (fd, dskloc, SEEK_SET) < 0)
      {
	 perror ("seek failed");
	 exit (ABORT);
      }

      /*
      ** Read sector
      */

      for (i = 0; i < sectlen; i++)
	 buf[i] = fgetc (fd);
      /*
      ** Dump it
      */
      printf ("\ntrack %d sect %d dskloc = %d:\n", track, j, dskloc);
      HEXDUMP (stdout, buf, sectlen, 0);
   }

   return (NORMAL);
}
