/***********************************************************************
*
* fd800defs.h - Definition for FD800 floppy disk.
*
* Changes:
*   12/17/08   DGP   Original.
*
***********************************************************************/

#ifndef __FD800DEFS_H__
#define __FD800DEFS_H__

/*
** Disk geometry stuff
*/

#define FPYMAXAUS 333	/* Max Allocation units (AU) on disk */
#define FPYSECAU 6	/* Sectors per AU */

#define FPYTRKDRV 77	/* Tracks per drive */
#define FPYSECTRK 26	/* Sectors per track */
#define FPYSECLEN 128	/* Sector length */

/*
** Skew (interleaving) table
*/

static int fpyskew[26] = {
    4,10,16,22, 2, 8,
   14,20, 0, 6,12,18,
   24, 5,11,17,23, 3,
    9,15,21, 1, 7,13,
   19,25
};

#endif
