#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <ctype.h>
#include <errno.h>

#include "utiltypes.h"
#include "fd800defs.h"

main (int argc, char **argv)
{
    FILE *ifd, *ofd;
    int i;
    char buff[256];

    if (argc != 3)
    {
        fprintf (stderr, "USAGE: %s forthdat.fpy screen.txt\n", argv[0]);
	return 1;
    }

    if ((ifd = fopen (argv[1], "rb")) == NULL)
    {
        perror ("Can't open input file");
	return 1;
    }
    if ((ofd = fopen (argv[2], "w")) == NULL)
    {
        perror ("Can't open output file");
	return 1;
    }

    for (i = 0; i < FPYTRKDRV*FPYSECTRK; i++)
    {
	int j;
        if (fread (buff, 1, FPYSECLEN, ifd) != FPYSECLEN)
	    break;
	buff[FPYSECLEN] = '\n';
	for (j = 0; j < FPYSECLEN; j++)
	    if (buff[j] < 0x20 || buff[j] > 0x7E) buff[j] = ' ';
	fwrite (buff, 1, FPYSECLEN+1, ofd);
    }

    fclose (ifd);
    fclose (ofd);

}
