/***********************************************************************
*
* loader.c - Binary loader for the TI-990.
*
* This is a minimal loader, any linking/external object tags generate
* an error. Only uncompressed object is supported.
*
***********************************************************************/

#include <stdlib.h>
#include <stdio.h>

#include "utildef.h"

extern uint16 pcreg;
static uint16 *memory;

static uint16
gethex (uint8 *op)
{
   uint16 ret;
   int i;

   ret = 0;
   for (i = 0; i < 4; i++)
   {
      uint8 ch;

      ch = op[i] - '0';
      if (ch > 9) ch -= 7;
      ret = (ret << 4) | ch;
   }
   return (ret);
}

int
loadrec (uint8 *inbuf, int loadaddr, int *curraddr)
{
   uint8 *op = inbuf;
   int i, j;
   int cksum;

   memory = 0;
   if (*op == EOFSYM)
      return (EOF);

   cksum = 0;
   for (i = 0; i < 80; i++)
   {
      uint16 wdata;
      uint8 otag;

      otag = *op++;
      cksum += otag;
      wdata = gethex (op);
      if (otag != CKSUM_TAG)
	 for (j = 0; j < 4; j++) cksum += op[j];
      op += WORDTAGLEN - 1;
#ifdef DEBUGLOADER
      printf ("loadaddr = %04X, curraddr = %04X, otag = %c, data = %04X\n",
	       loadaddr, *curraddr, otag == 0x01 ? '0' : otag, wdata);
#endif

      switch (otag)
      {
      case IDT_TAG:
	 for (j = 0; j < IDTLEN; j++) cksum += *op++;
         break;

      case RELORG_TAG:
	 wdata += loadaddr;
      case ABSORG_TAG:
	 *curraddr = wdata;
	 break;

      case RELDATA_TAG:
	 wdata += loadaddr;
      case ABSDATA_TAG:
	 memory[*curraddr >> 1] = wdata;
	 *curraddr += 2;
	 break;

      case RELENTRY_TAG:
	 wdata += loadaddr;
      case ABSENTRY_TAG:
	 pcreg = wdata;
	 break;

      case CKSUM_TAG:
         cksum += (int16)wdata;
	 if (cksum != 0)
	 {
#ifdef DEBUGLOADER
	    printf ("Checksum error");
#endif
	    return (-20);
	 }
      case NOCKSUM_TAG:
         break;

      case EOR_TAG:
         i = 81;
	 break;

      default: 
#ifdef DEBUGLOADER
	 printf ("Illegal object tag: %c(%02X), %9.9s",
	 	  otag, otag, &inbuf[71]);
#endif
	 return (-22);
      }
   }
   return (0);
}
