	IDT	'PDISK'
	TITL	'Put to disk from serial port'
*
* PDISK - Reads disk image from serial port and writes to disk.
*
R0	EQU	0
R1	EQU	1
R2	EQU	2
R3	EQU	3
R4	EQU	4
R5	EQU	5
R6	EQU	6
R7	EQU	7
R8	EQU	8
R9	EQU	9
R10	EQU	10
R11	EQU	11
R12	EQU	12
R13	EQU	13
R14	EQU	14
R15	EQU	15
*
* Terminal CRU bits and codes
*
TRMCRU	EQU	>0		Terminal CRU
*
XMIT	EQU	8
DTR	EQU	9
RTS	EQU	10
WRQ	EQU	11
RRQ	EQU	12
NSF	EQU	13
ENINT	EQU	14
*
*
* Disk commands and codes
*
DEVADR	EQU	>F800		Disk TILINE address
DEVUNT	EQU	>0800		Disk Unit 0 = >0800
*					  1 = >0400
*					  2 = >0200
*					  3 = >0100
*
STRRCM	EQU	>0000		Store registers
READCM	EQU	>0200		Read
WRITCM	EQU	>0300		Write
REDUCM	EQU	>0400		Read unformatted
SEEKCM	EQU	>0600		Seek
RESTCM	EQU	>0700		Restore
*
ERRMSK	EQU	>21FF
MAXSEC	EQU	288
*
PNLCRU	EQU	>1FE0		Front panel CRU
	PAGE
*
* Entry
*
*	AORG	>1000
SAENT	EQU	$
	LWPI	WS
	LIMI	0		Take over the system
*
	LI	R1,ZEROBF	Clear zero sector.
	LI	R2,MAXSEC
ZER010	CLR	*R1+
	DECT	R2
	JGT	ZER010
*
	CLR	R15
	LI	R1,RESTCM	Restore disk
	MOV	R1,@DSKCMD
	LI	R1,DEVUNT
	MOV	R1,@DSKUNT
	LI	R1,6
	MOV	R1,@DSKLEN
	CLR	@DSKTRK
	CLR	@DSKSEC
	CLR	@DSKHED
	BLWP	@DISKH
	DATA	DSKPRM,0,OOPS1
*
	LI	R1,STRRCM	Store registers
	MOV	R1,@DSKCMD
	BLWP	@DISKH
	DATA	DSKPRM,DSKREG,OOPS2
*
	LI	R1,REDUCM	Read unformatted
	MOV	R1,@DSKCMD
	BLWP	@DISKH
	DATA	DSKPRM,DSKUBF,OOPS3
*
	LI	R12,TRMCRU
	SBO	DTR
	SBO	RTS
	SBZ	ENINT
	BLWP	@PRINT		Issue ready message
	DATA	READY,RDYLEN
WAITCH	EQU	$
	TB	RRQ
	JNE	$-2
	STCR	R1,8		Get reply
	SBZ	RRQ
	CB	R1,@KILL	If ch = KILL then
	JNE	WAIT10
	B	@TSKXIT		  EXIT
WAIT10	CB	R1,@NEWLIN	If ch != NEWLINE then
	JNE	WAITCH		   wait
*
	BLWP	@READ		Get heads
	DATA	HEADS,2
	BLWP	@READ		Get sectors/track
	DATA	SECTRK,2
	BLWP	@READ		Get sector length
	DATA	SECLEN,2
*
	MOV	@DSKREG+4,R0
	SRL	R0,11
	C	R0,@HEADS
	JNE	OOPS5
	MOV	@DSKREG+2,R0
	SRL	R0,8
	C	R0,@SECTRK
	JNE	OOPS6
	CLR	R2		Calc bytes/sector
	MOV	@DSKREG,R3	Get words/track
	MOV	@DSKREG+2,R4	Get sectors/track
	SRL	R4,8
	DIV	R4,R2		Words/track / Sectors/track = Words/sector
	MOV	@DSKREG+2,R4	Get overhead/sector (words)
	ANDI	R4,>00FF
	S	R4,R2		Minus overhead
	SLA	R2,1		Make bytes/sector
	MOV	R2,@DSKLEN
	MOV	R2,@REDLEN
	C	R2,@SECLEN
	JNE	OOPS7
	MOV	@DSKREG+4,R4	Get tracks (cylinders)
	ANDI	R4,>7FF
	CLR	R7		Track counter
NXTTRK	EQU	$
	MOV	R7,@DSKTRK
	MOV	@DSKREG+4,R5	Get Heads
	SRL	R5,11
	CLR	R6		Head counter
NXTHED	EQU	$
	LI	R1,WRITCM	Write sector
	A	R6,R1		Add head
	MOV	R1,@DSKCMD
	MOV	@DSKREG+2,R3	Get Sectors/track
	SRL	R3,8
	CLR	R1		Sector counter
NXTSEC	EQU	$
	MOV	@DSKUBF+2,R10	Get record/sector
	ANDI	R10,>FF00
	SOC	R1,R10	
	MOV	R10,@DSKSEC	Save sector
	MOV	R7,R10		Display TTTT TTTT TTTH HHHH
	SLA	R10,5		 
	SOC	R6,R10
	LI	R12,PNLCRU	  on front panel...
	LDCR	R10,8
	SWPB	R10
	LDCR	R10,8
	BLWP	@PRINT		Tell sender to start sector
	DATA	READY,1
	BLWP	@READ		Get size of this sector
	DATA	SECLEN,2
	MOV	@SECLEN,R10	If negative, write all zero sector.
	JGT	DOREAD
	BLWP	@DISKH		Write a sector of zeros
	DATA	DSKPRM,ZEROBF,OOPS4
	JMP	CHKNXT
DOREAD	BLWP	@READ		Read a sector.
	DATA	DSKBUF
REDLEN	DATA	$-$
	BLWP	@DISKH		Write a sector
	DATA	DSKPRM,DSKBUF,OOPS4
CHKNXT	INC	R1		Next sector
	DEC	R3		Last sector on this track?
	JGT	NXTSEC		No, read next sector
	INC	R6		Next head
	DEC	R5		Last head?
	JGT	NXTHED		No, read next head
	INC	R7		Yes, next track
	DEC	R4		Last track?
	JGT	NXTTRK		No, read next track
	BLWP	@PRINT		Tell sender to continue.
	DATA	READY,1
*
TSKXIT	EQU	$
	LI	R12,PNLCRU	Put status on front panel
	LDCR	R15,8
	SWPB	R15
	LDCR	R15,8
	IDLE			We're done.
*
OOPS7	EQU	$		Sector length mismatch.
	INC	R15
OOPS6	EQU	$		Sector/track mismatch.
	INC	R15
OOPS5	EQU	$		Heads mismatch.
	INC	R15
OOPS4	EQU	$		Write sector error.
	INC	R15
OOPS3	EQU	$		Read unformatted error.
	INC	R15
OOPS2	EQU	$		Store registers error.
	INC	R15
OOPS1	EQU	$		Restore error.
	INC	R15
	LI	R0,>DEAD
	MOV	R15,R1
	JMP	TSKXIT
*
WS	DATA	0,0,0,0,0,0,0,0
	DATA	0,0,0,0,TRMCRU,0,0,0
*
KILL	DATA	>0300		CTRL-C
XON	DATA	>1100
XOFF	DATA	>1300
*
READY	EQU	$
	BYTE	>0D
NEWLIN  BYTE	>0A
	TEXT	'Enter NEWLINE key when ready: '
RDYLEN	EQU	$-READY
ERRMSG	EQU	$
	BYTE	>0D,>0A
	TEXT	'ERROR: '
ERRCOD	BYTE	'X'
ERRLEN	EQU	$-ERRMSG
	EVEN
*
DSKPRM	EQU	$
DSKCMD	DATA	$-$		Command
DSKHED	DATA	$-$		Head
DSKSEC	DATA	$-$		Sector
DSKTRK	DATA	$-$		Track
DSKLEN	DATA	$-$		Sector length
DSKUNT	DATA	$-$		Unit
DSKREG	BSS	6		Disk registers
DSKUBF	BSS	6		Disk unformatted read
*
HEADS	BSS	2
SECTRK	BSS	2
SECLEN	BSS	2
	PAGE
*
* Read a buffer from terminal.
*
READ	DATA	PRWS,REDENT
REDENT	MOV	*R14+,R2	Get buffer address
	MOV	*R14+,R1	Get buffer length
RED010	TB	RRQ
	JNE	RED010
	STCR	*R2+,8
	SBZ	RRQ
	DEC	R1
	JGT	RED010
	RTWP
*
* Print a message
*
PRINT	DATA	PRWS,PRENT
PRENT	EQU	$
	MOV	*R14+,R2	Get buffer address
	MOV	*R14+,R1	Get message length
	SBO	DTR
	SBO	RTS
PRI010	LDCR	*R2+,8		Put it out
	TB	WRQ
	JNE	$-2
	SBZ	WRQ
	TB	RRQ		Any thing coming back?
	JEQ	PRI030		Yes, go check it.
PRI020	EQU	$
	DEC	R1
	JGT	PRI010
	CLR	@0(R13)		Done, exit 0.
	RTWP
*
PRI030	EQU	$
	STCR	R5,8		Get it.
	SBZ	RRQ
	CB	R5,@XOFF	If XOFF then
	JEQ	PRI040		   go wait for XON
	CB	R5,@KILL	If not KILL (CTRL-C) then
	JNE	PRI020		   Ignore.
	SETO	@0(R13)		else exit -1.
	RTWP
PRI040	EQU	$
	TB	RRQ		Wait for XON.
	JNE	PRI040
	STCR	R5,8
	SBZ	RRQ
	CB	R5,@XON
	JEQ	PRI020
	JMP	PRI040
*
PRWS	DATA	0,0,0,0,0,0,0,0
	DATA	0,0,0,0,TRMCRU,0,0,0
	PAGE
*
* Disk Handler
*
DISKH	DATA	DISKWS,DISKEP
DISKWS	DATA	0,0,0,0,0,0,0,0
	DATA	0,0,0,0,DEVADR,0,0,0
DISKEP	EQU	$
	MOV	R12,R7
	AI	R7,14
	MOV	R14,R10		Ignore error now
	CLR	R9
	BL	@BZYCHK
	MOV	*R14+,R10	Get parm addr
	MOV	*R10+,R0	Get disk command
	MOV	*R10+,R1	Get head
	SOC	R1,R0
	MOV	*R10+,R1	Get Sector
	MOV	*R10+,R2	Get Track
	MOV	*R10+,R3	Get Length
	MOV	*R14+,R4	Get buffer addr
	MOV	*R10+,R5	Get Unit
	MOV	*R14+,R10	Get error vector
	MOV	R0,R9		Check if seek or restore
	ANDI	R9,>0F00
	CI	R9,SEEKCM
	JLT	DSK010
	MOV	R5,R9
	SRL	R9,4
	JMP	DSK020
DSK010	CLR	R9
DSK020	BL	@ISSUE
	RTWP
*
ISSUE	MOV	R12,R7		Issue TILINE command
	CLR	*R7+
	MOV	R0,*R7+
	MOV	R1,*R7+
	MOV	R2,*R7+
	MOV	R3,*R7+
	MOV	R4,*R7+
	MOV	R5,*R7+
	CLR	*R7		Start transfer
BZYCHK	MOV	*R7,R8		Get status
	JLT	ISU020		Done?
	JMP	BZYCHK		No, wait.
ISU020	MOV	R9,R9		Seek or Restore?
	JEQ	ISU025		No, go on.
	MOV	*R12,R6		Yes, check attention bits.
	COC	R9,R6
	JNE	BZYCHK
ISU025	ANDI	R8,ERRMSK	Yes, Errors?
	JEQ	ISU030		No
	MOV	R10,R14		Yes, set error vector.
	MOV	*R12,@4(R13)
	MOV	*R7,@6(R13)	Set error status.
ISU030	RT
*
DSKBUF	BSS	MAXSEC
ZEROBF	BSS	MAXSEC
	END	SAENT
