/***********************************************************************
*
* SETDSK - Load TI-990 disk image with HHSSCC data.
*
* Changes:
*   10/27/17   DGP   Original
*
***********************************************************************/

#include <stdio.h>
#include <string.h>

#include "diskio.h"
#ifdef DEBUG
#include "hexdump.h"
#endif

#define BLOCKSIZE 512
#define SECSBLOCK 40

static char buffer[BLOCKSIZE*SECSBLOCK];

extern void lights(int);

static int
getnum (char *buf)
{
   unsigned char *bp = (unsigned char *)buf;
   return (bp[0] << 8 | bp[1]);
}

int
main (int argc, char **argv)
{
   long outsecs;
   int done;
   int i, j, k;
   int cyls, heads, sects, sectlen;
   int cyl, head, sect, len;
   int zerodisk, maxcyl;
   int *bufadd;
   int debug;
   int ch;

   zerodisk = 0;
   debug = 0;
   maxcyl = -1;
   for (i = 1; i < argc; i++)
   {
      char *ap = argv[i];
      if (*ap == '-')
      {
         ap++;
         if (*ap == 'd')
	    debug = 1;
         else
	 {
	 USAGE:
	    printf ("usage: setdsk [-d]\n");
	    return (1);
	 }
      }
      else
         goto USAGE;
   }

   if (diskinit (0) < 0)
   {
      printf ("tload: can't initialize disk\n");
      return (1);
   }
   
   if (diskgeometry (0, &cyls, &heads, &sects, &sectlen) < 0)
   {
      printf ("setdsk: can't get disk geometry\n");
      return (1);
   }

   printf ("setdsk: Disk Geometry:\n");
   printf ("   cyls = %d, heads = %d, sects = %d, sectlen = %d\n",
	   cyls, heads, sects, sectlen);

   printf ("setdsk: press enter to start: ");
   fflush (stdout);
   ch = getchar();

   if (maxcyl < 0) maxcyl = cyls;
   printf ("setdsk: write disk, cyls = %d\n", maxcyl);

   memset (buffer, 0, sectlen);
   bufadd = (int *)buffer[0];

   for (i = 0; i < maxcyl; i++)
   {
      for (k = 0; k < heads; k++)
      {
	 lights (i << 5 | k);
	 for (j = 0; j < sects; j++)
	 {
	    bufadd[0] = i;
	    bufadd[1] = k;
	    bufadd[2] = j;

	    if (diskwrite (0, i, k, j, buffer, sectlen) < 0)
	    {
	       printf ("setdsk: can't write disk\n");
	       return (1);
	    }
	 }
      }
   }
   printf ("tload: DONE: %ld sectors written\n", outsecs);
   return (0);
}
