/***********************************************************************
*
* SPLITOBJ - Split an object archive (sequential library) into individual
*            object files.
*
* Changes:
*      02/10/11   DGP   Original
*
***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define RECLEN 80

/***********************************************************************
* main
***********************************************************************/

int
main (int argc, char **argv)
{
   FILE *ifd, *ofd;
   int done;
   int start;
   int i;
   int status;
   char buff[RECLEN+2];
   char name[10];
   char outname[BUFSIZ];
   struct stat stbuf;

   if (argc != 3)
   {
      fprintf (stderr, "splitobj inputarchive outputdir\n");
      exit (1);
   }

   if ((ifd = fopen (argv[1], "rb")) == NULL)
   {
      fprintf (stderr, "Can't open input file: %s: %s\n",
	       argv[1], strerror(errno));
      exit (1);
   }

   if (stat (argv[2], &stbuf) < 0)
   {
      fprintf (stderr, "Can't stat directory: %s: %s\n",
	       argv[2], strerror(errno));
      exit (1);
   }
   else if (!S_ISDIR(stbuf.st_mode))
   {
      fprintf (stderr, "Directory: %s: %s\n",
	       argv[2], strerror(ENOTDIR));
      exit (1);
   }

   start = TRUE;
   done = FALSE;
   ofd = NULL;
   status = 0;

   while (!done)
   {
      if (fread (buff, 1, RECLEN+1, ifd) != RECLEN+1)
      {
         if (feof(ifd))
	 {
	    done = TRUE;
	    continue;
	 }
	 if (ferror(ifd))
	 {
	    fprintf (stderr, "Can't read file: %s\n", argv[1]);
	    status = 1;
	    done = TRUE;
	    continue;
	 }
      }

      if (start)
      {
         if (buff[0] == 0x01 || buff[0] == '0')
	 {
	    if (buff[0] == 0x01)
	       strncpy (name, &buff[3], 8);
	    else
	       strncpy (name, &buff[5], 8);
	    for (i = 7; i && name[i] == ' '; i--) ;
	    name[i+1] = 0;
	    sprintf (outname, "%s/%s.obj", argv[2], name);
	    if ((ofd = fopen (outname, "wb")) == NULL)
	    {
	       fprintf (stderr, "Can't open output file: %s: %s\n",
			outname, strerror(errno));
	       status = 1;
	       done = TRUE;
	       continue;
	    }
	    if (fwrite (buff, 1, RECLEN+1, ofd) != RECLEN+1)
	    {
	       fprintf (stderr, "Can't write file: %s\n", outname);
	       status = 1;
	       done = TRUE;
	       continue;
	    }
	    start = FALSE;
	 }
      }
      else
      {
	 if (fwrite (buff, 1, RECLEN+1, ofd) != RECLEN+1)
	 {
	    fprintf (stderr, "Can't write file: %s\n", outname);
	    status = 1;
	    done = TRUE;
	    continue;
	 }
	 if (buff[0] == ':')
	 {
	    fclose (ofd);
	    ofd = NULL;
	    start = TRUE;
	 }
      }
   }

   if (ofd)
      fclose (ofd);
   fclose (ifd);

   return (status);
}
