/***********************************************************************
*
* TBOOT - Boot TI-990 from tape.
*
* Changes:
*   07/13/16   DGP   Original
*
***********************************************************************/

#include <stdio.h>

#include "tapeio.h"

extern int loadrec (unsigned char *, int, int *);
extern void transfer (unsigned int);

unsigned int pcreg;

static unsigned char buffer[82];

int
main (int argc, char **argv)
{
   int done;
   int lp, clp;

   if (taperewind (0) < 0)
   {
      printf ("tboot: can't rewind tape\n");
      return (1);
   }

   lp = clp = 0xa0;
   pcreg = 0;
   done = 0;
   while (!done)
   {
      if (taperead (0, (char *)buffer, sizeof(buffer)) < 0)
      {
	 printf ("tboot: can't read tape\n");
	 return (1);
      }

      if ((done = loadrec (buffer, lp, &clp)) != 0)
      {
	 if (done != EOF)
	    printf ("tboot: loader error\n");
         done = 1;
      }
   }

   if (pcreg)
      transfer (pcreg);
}
