/***********************************************************************
*
* utildef.h - Utilities header for the TI 990 computer.
*
* Changes:
*   05/05/05   DGP   Original.
*   11/10/08   DGP   Added /12 support.
*   02/09/11   DGP   Added CSEG support.
*   08/09/11   DGP   Added CPU model support.
*   08/17/11   DGP   Allow multiple CSEGs.
*
***********************************************************************/

#include <stdio.h>
#include "utiltypes.h"

/*
** Definitions
*/

#define NORMAL 0
#define ABORT  12

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define VERSION "1.5.1"

#define EOFSYM ':'

#define MAXLINE 256
#define LINESPAGE 60
#define MAXFILES 30
#define IDTSIZE 8

#define MAXCSEGS 10

#define MSB 0
#define LSB 1

/*
** Instruction types
*/

enum optypes
{
   TYPE_1=0, TYPE_2,  TYPE_3,  TYPE_4,  TYPE_5,  TYPE_6,  TYPE_7,  TYPE_8,
   TYPE_9,   TYPE_10, TYPE_11, TYPE_12, TYPE_13, TYPE_14, TYPE_15, TYPE_16,
   TYPE_17,  TYPE_18, TYPE_19, TYPE_20, TYPE_21, TYPE_ILL
};

/*
** Memory
*/

#define MEMSIZE 65768

typedef struct
{
   char tag;
   int	value;
   int	relocatable;
   int  external;
   int  global;
   int  used;
} Memory;

#define GETMEM(m) \
(((memory[(m)+MSB] & 0xFF) << 8)|(memory[(m)+LSB] & 0xFF))

#define PUTMEM(m,v) \
{ memory[(m)+MSB] = (v) >> 8 & 0xFF; memory[(m)+LSB] = (v) & 0xFF; }

#define GETDSEGMEM(m) \
(((dsegmem[(m)+MSB] & 0xFF) << 8)|(dsegmem[(m)+LSB] & 0xFF))

#define PUTDSEGMEM(m,v) \
{ dsegmem[(m)+MSB] = (v) >> 8 & 0xFF; dsegmem[(m)+LSB] = (v) & 0xFF; }

#define GETCSEGMEM(n,m) \
(((csegmem[n][(m)+MSB] & 0xFF) << 8)|(csegmem[n][(m)+LSB] & 0xFF))

#define PUTCSEGMEM(n,m,v) \
{ csegmem[n][(m)+MSB] = (v) >> 8 & 0xFF; csegmem[n][(m)+LSB] = (v) & 0xFF; }

/*
** Symbol table
*/

#define MAXSYMLEN 32
#define MAXSHORTSYMLEN 6
#define MAXSYMBOLS 5000

#define RELOCATABLE 0x000000001
#define EXTERNAL    0x000000002
#define GLOBAL      0x000000004
#define LONGSYM     0x000000008
#define MULDEF      0x000000010
#define UNDEF       0x000000020
#define DSEG        0x000000040
#define CSEG        0x000000080
#define ABSDEF      0x000000100
#define SREF        0x000000200
#define LOAD        0x000000400

typedef struct
{
   char symbol[MAXSYMLEN+2];
   char module[MAXSYMLEN+2];
   int flags;
   int value;
   int order;
   int cmnndx;
} SymNode;

/*
** Module table
*/

#define MAXMODULES 2

typedef struct 
{
   char name[IDTSIZE+2];
   char date[12];
   char time[12];
   char creator[12];
   char objfile[256];
   int origin;
   int length;
} Module;

/*
** Object tags
*/

#define BINIDT_TAG	01
#define IDT_TAG		'0'
#define ABSENTRY_TAG	'1'
#define RELENTRY_TAG	'2'
#define RELEXTRN_TAG	'3'
#define ABSEXTRN_TAG	'4'
#define RELGLOBAL_TAG	'5'
#define ABSGLOBAL_TAG	'6'
#define CKSUM_TAG	'7'
#define NOCKSUM_TAG	'8'
#define ABSORG_TAG	'9'
#define RELORG_TAG	'A'
#define ABSDATA_TAG	'B'
#define RELDATA_TAG	'C'
#define LOADBIAS_TAG	'D'
#define EXTNDX_TAG	'E'
#define EOR_TAG		'F'

#define RELSYMBOL_TAG	'G'
#define ABSSYMBOL_TAG	'H'
#define PGMIDT_TAG	'I'
#define CMNSYMBOL_TAG	'J'
#define COMMON_TAG	'M'
#define CMNDATA_TAG	'N'
#define CMNORG_TAG	'P'
#define CBLSEG_TAG	'Q'
#define DSEGORG_TAG	'S'
#define DSEGDATA_TAG	'T'
#define LOAD_TAG	'U'
#define RELSREF_TAG	'V'
#define CMNGLOBAL_TAG	'W'
#define CMNEXTRN_TAG	'X'
#define ABSSREF_TAG	'Y'
#define CMNSREF_TAG	'Z'

#define LRELSYMBOL_TAG	'i'
#define LABSSYMBOL_TAG	'j'
#define LRELEXTRN_TAG	'l'
#define LABSEXTRN_TAG	'm'
#define LRELGLOBAL_TAG	'n'
#define LABSGLOBAL_TAG	'o'
#define LLOAD_TAG	'p'
#define LRELSREF_TAG	'q'
#define LABSSREF_TAG	'r'

#define CHARSPERREC	66  /* Chars per object record */
#define CHARSPERCASREC	73  /* Chars per cassette object record */
#define WORDTAGLEN	5   /* Word + Object Tag length */
#define BINWORDTAGLEN	3   /* Word + Binary Object Tag length */
#define SYMLEN		6   /* Symbol length */
#define IDTLEN		8   /* IDT length */
#define IDTCOLUMN	72  /* Where to put the IDT */
#define SEQUENCENUM	76  /* Where to put the sequence */

#define TIMEOFFSET 17
#define DATEOFFSET 27
#define CREATOROFFSET 38

extern int disloader (FILE *, int, char *);

extern void disprog (int, int);

extern SymNode *symlookup (char *, char *, int);
extern SymNode *vallookup (int, int, int, int);
extern SymNode *extlookup (int, int);
extern SymNode *symadd (char *, int);
