#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>

#undef NULL

#ifdef USESOCKET
#include <memory.h>
#include <netdb.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/timeb.h>
#else
#include "inet.h"
#include "net.h"
#include "con.h"
#include "udp.h"
#endif

#ifdef USESOCKET
static struct sockaddr_in saddr;
static struct sockaddr_in caddr;
static int ssd;
#else
static struct con con;
#endif
static char msg[2048];
static int sd;

static void 
sigcatcher (sig)
   int sig;
{
   if (sd)
      close (sd);
}

int
main (argc, argv)
     int argc;
     char **argv;
{
   char *bp;
   struct udp *up;
   int done, i;
   int len, mlen, rlen;
   int port;
   int reply, tcptest;

   sd = 0;
   tcptest = 0;
   reply = 0;
   port = 4000;
   len = 0;
   mlen = 256;

   /*
    ** Scan off args 
    */

   for (i = 1; i < argc; i++)
   {
      bp = argv[i];

      if (*bp == '-')
      {
         for (bp++; *bp; bp++)
            switch (*bp)
            {
	    case 'l':
	       i++;
	       mlen = atoi (argv[i]);
	       break;

            case 'r':
               reply = 1;
               break;

            case 't':
               tcptest = 1;
               break;

            default:
	       USAGE:
               printf ("usage: netserv [-options] port\n");
               printf (" options:\n");
	       printf ("    -l number    - Length of messages\n");
               printf ("    -r           - Process reply\n");
               printf ("    -t           - TCP\n");
               return (1);
            }
      }
      else if (len == 0)
      {
         port = atoi(argv[i]);
	 len++;
      }
      else
         goto USAGE;
   }

   printf ("Start: len = %d, port = %d, tcp = %d, reply = %d\n",
	   mlen, port, tcptest, reply);

   signal (SIGINT, sigcatcher);

   if (!tcptest)
   {
#ifdef USESOCKET
      printf ("UDP test not supported in USESOCKET mode\n");
#else
      struct socket ip;

      printf ("Open UDP socket\n");
      memset (&con, 0, sizeof (struct con));
      con.c_mode = CONUDP | CONRAWVER;
      con.c_fport = 0;
      con.c_lport = port;
      con.c_fcon.s_addr = 0;
      con.c_lcon.s_addr = 0;
      con.c_sbufs = con.c_rbufs = 1;

      sd = netopen (&con);
      printf ("   sd = %d, error = %d\n", sd, errno);
      if (errno)
         goto BADNESS;

      while (1)
      {
         len = read (sd, msg, sizeof (msg));
	 printf ("   len = %d, error = %d\n", len, errno);
         if (len <= 0) {
	    break;
	 }
	 if (reply) {
	    /* swap the addresses and ports */
	    up = (struct udp *)msg;
	    ip = up->u_s;
	    up->u_s = up->u_d;
	    up->u_d = ip;
	    i = up->u_src;
	    up->u_src = up->u_dst;
	    up->u_dst = i;
	    if (write (sd, msg, len) < 0)
	       break;
	 }
      }
#endif
   }

   else
   {
      printf ("Open TCP socket\n");

#ifdef USESOCKET
      saddr.sin_port = htons (port);
      if ((ssd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	      fprintf (stderr, "socket error: %s\n",
		       strerror(errno));
		       exit(1);
      }
      if (bind (ssd, (struct sockaddr *)&saddr, sizeof(saddr)) < 0) {
	      fprintf (stderr, "bind error: %s\n",
		       strerror(errno));
		       exit(1);
      }
      if (listen (ssd, 1)) {
	      fprintf (stderr, "listen error: %s\n",
		       strerror(errno));
		       exit(1);
      }
      i = sizeof (struct sockaddr_in);
      if ((sd = accept (ssd, (struct sockaddr *)&caddr, (void *)&i)) < 0) {
	      fprintf (stderr, "accept error: %s\n",
		       strerror(errno));
		       exit(1);
      }
#else
      memset (&con, 0, sizeof (struct con));
      con.c_mode = CONTCP;
      con.c_fport = 0;
      con.c_lport = port;
      con.c_fcon.s_addr = 0;
      con.c_lcon.s_addr = 0;
      con.c_sbufs = con.c_rbufs = 1;

      sd = netopen (&con);
#endif
      printf ("   sd = %d, error = %d\n", sd, errno);
      if (errno)
         goto BADNESS;

      i = 0;
      done = 0;
      while (!done)
      {
	 printf ("\nRead msg %d\n", i);
	 rlen = 0;
	 while (rlen < mlen)
	 {
	    len = read (sd, &msg[rlen], mlen - rlen);
	    if (len <= 0) {
	       done = 1;
	       break;
	    }
	    rlen += len;
	    printf ("   read %d bytes\n", len);
	 }
	 if (!done && reply) {
	    printf ("Write msg %d\n", i);
	    rlen = 0;
	    while (rlen < mlen)
	    {
	       len =  write (sd, &msg[rlen], mlen - rlen);
	       if (len < 0) {
		  done = 1;
		  break;
	       }
	       rlen += len;
	       printf ("   wrote %d bytes\n", len);
	    }
	    printf ("message %d: mlen = %d\n", i, mlen);
	 }
	 i++;
      }
   }

 BADNESS:
   if (errno)
      printf ("ERROR = %d\n", errno);
   close (sd);
   return 0;
}
