#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>

#undef NULL

#ifdef USESOCKET
#include <memory.h>
#include <netdb.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/timeb.h>
#else
#include "inet.h"
#include "net.h"
#include "con.h"
#include "udp.h"
#endif

#ifdef USESOCKET
static struct sockaddr_in waddr;
#else
static struct con con;
#endif

static char str[] = "Hello world!\n";
static char imsg[2048];
static char omsg[2048];
static int sd;

static void 
sigcatcher (sig)
   int sig;
{
   if (sd)
      close (sd);
}

int
main (argc, argv)
     int argc;
     char **argv;
{
   unsigned long ip_addr;
   char *bp;
   int lcnt, i, err;
   int rlen, mlen, len;
   int tcptest;
   int readreply;
   int port;

   ip_addr = 0;
   sd = 0;
   lcnt = 1;
   tcptest = 0;
   readreply = 0;
   len = 0;
   mlen = 256;
   port = 4000;

   /*
    ** Scan off args 
    */

   for (i = 1; i < argc; i++)
   {
      bp = argv[i];

      if (*bp == '-')
      {
         for (bp++; *bp; bp++)
            switch (*bp)
            {
            case 'l':
               i++;
               mlen = atoi (argv[i]);
               break;

            case 'n':
               i++;
               lcnt = atoi (argv[i]);
               break;

            case 'r':
               readreply = 1;
               break;

            case 't':
               tcptest = 1;
               break;

            default:
	    USAGE:
               printf ("usage: nettest [-options] host [port]\n");
               printf (" options:\n");
               printf ("    -l number    - Length of messages to send\n");
               printf ("    -n number    - Number of messages to send\n");
               printf ("    -r           - Read reply\n");
               printf ("    -t           - Send over TCP\n");
               return (1);
            }
      }
      else if (len == 0)
      {
#ifdef USESOCKET
         ip_addr = inet_addr (argv[i]);
#else
         ip_addr = gethost (argv[i]);
#endif
	 len++;
      }
      else if (len == 1)
      {
         port = atoi (argv[i]);
	 len++;
      }
      else 
      {
         goto USAGE;
      }
   }
   if (ip_addr == 0)
      goto USAGE;

#ifdef USESOCKET
   memset ((char *)&waddr, 0, sizeof(waddr));
   waddr.sin_family = AF_INET;
   waddr.sin_port = htons (port);
   waddr.sin_addr.s_addr = ip_addr;
   bp = inet_ntoa(waddr.sin_addr);
#else
   memset (&con, 0, sizeof (struct con));
   bp = inet_ntoa(ip_addr);
#endif

   printf (
    "Start: addr = %s, port = %d, tcp = %d, reply = %d, count = %d, len = %d\n",
       bp, port, tcptest, readreply, lcnt, mlen);


   signal (SIGINT, sigcatcher);

   for (i = 0; i < mlen; i++)
      omsg[i] = i & 0xFF;
   strcpy (omsg, str);

   if (!tcptest)
   {
#ifdef USESOCKET
      printf ("UDP test not supported in USESOCKET mode\n");
#else
      printf ("Open UDP socket\n");
      con.c_mode = CONUDP | CONACT | CONRAWCOMP;

      con.c_fcon.s_addr = ip_addr;
      con.c_lcon.s_addr = 0;

      con.c_fport = port;
      con.c_lport = port;
      con.c_timeo = 60;

      sd = netopen (&con);
      if (errno)
         goto BADNESS;
      printf ("socket# %d\n", sd);

      for (i = 0; i < lcnt; i++)
      {
         printf ("Write msg %d\n", i);
         err = write (sd, omsg, mlen);
         if (err < 0)
            goto BADNESS;

         if (readreply)
         {
            printf ("Read msg %d\n", i);
            len = read (sd, imsg, sizeof (imsg));
            if (len > 0) {
               printf ("Received %d bytes\n", len);
               printf ("Message: %s\n", imsg + sizeof (struct udp));
            }
            else {
               printf ("NO REPLY\n");
               if (errno)
                  goto BADNESS;
	    }
         }
      }
#endif
   }

   else
   {
      printf ("Open TCP socket\n");

#ifdef USESOCKET
      if ((sd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        		fprintf (stderr, "write socket error: %s\n",
				 strerror(errno));
      }
      if (connect (sd, (struct sockaddr *)&waddr, sizeof (waddr)) < 0) {
        		fprintf (stderr, "write connect error: %s\n",
				 strerror(errno));
         exit(1);
      }
#else
      con.c_mode = CONTCP | CONACT;
      con.c_fcon.s_addr = ip_addr;
      con.c_lcon.s_addr = 0;
      con.c_fport = port;
      con.c_lport = 5000;
      con.c_timeo = 60;

      sd = netopen (&con);
#endif
      if (sd < 0)
      {
         printf ("open failed: error = %d\n", errno);
         exit (1);
      }
      printf ("socket# %d\n", sd);

      for (i = 0; i < lcnt; i++)
      {
         printf ("Write msg %d\n", i);
	 rlen = 0;
	 while (rlen < mlen)
	 {
	    len = write (sd, &omsg[rlen], mlen - rlen);
	    if (len < 0) {
	       goto BADNESS;
	    }
	    printf ("   wrote %d bytes\n", len);
	    rlen += len;
	 }

         if (readreply)
         {
            printf ("Read msg %d\n", i);

	    rlen = 0;
	    while (rlen < mlen)
	    {
	       len = read (sd, &imsg[rlen], mlen - rlen);
	       if (len <= 0)
	       {
		  printf ("NO REPLY\n");
		  goto BADNESS;
	       }
	       printf ("   read %d bytes\n", len);
	       rlen += len;
	    }
	    printf ("Message: %s\n", imsg);
         }
      }
   }
   close (sd);
   return 0;

 BADNESS:
   if (errno)
      printf ("ERROR = %d\n", errno);
   close (sd);
   return 1;
}
